///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//  Copyright  NetworkDLS 2002, All rights reserved
//
// THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF 
// ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO 
// THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A 
// PARTICULAR PURPOSE.
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#ifndef _DIALOGS_TABADVANCED_CPP
#define _DIALOGS_TABADVANCED_CPP
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <Stdio.H>
#include <Stdlib.H>
#include <CommCtrl.h>
#include <ShlObj.H>

#include "../Resources/Resource.H"

#include "../../SharedSource/NSWFL.H"
#include "../Source/Entry.H"
#include "../Source/Routines.H"

#include "../Dialogs/MainDlg.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL CALLBACK TabAdvancedDialog(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	static HWND hSQLDatFileLoc = NULL;

	if(uMsg == WM_INITDIALOG)
    {
		hSQLDatFileLoc = GetDlgItem(hWnd, IDC_SQL_DATA_LOC);

		Set_Text(hSQLDatFileLoc, gsSQLDataFiles);

		if(gbCacheLogFile)
			CheckDlgButton(hWnd, IDC_CACHELOGFILE, BST_CHECKED);

		if(gbRTOFDWI)
			CheckDlgButton(hWnd, IDC_RTOFDWI, BST_CHECKED);

		if(gbStartAutomatically)
			CheckDlgButton(hWnd, IDC_AUTORUN, BST_CHECKED);

		if(gbShowSplashScreen)
			CheckDlgButton(hWnd, IDC_SHOWSPLASHSCREEN, BST_CHECKED);

		if(gbDropBadPackets)
			CheckDlgButton(hWnd, IDC_DROPBADPACKETS, BST_CHECKED);

		if(gbPacketMode)
			CheckDlgButton(hWnd, IDC_USEPACKEMODE, BST_CHECKED);

		if(gbVisualAlertOnError)
			CheckDlgButton(hWnd, IDC_ALERTONERRORS, BST_CHECKED);

		if(gbVisualAlertOnWarn)
			CheckDlgButton(hWnd, IDC_ALERTONWARNING, BST_CHECKED);

		return TRUE;
    }

	if(uMsg == WM_COMMAND)
    {
		if(wParam == IDC_BROWSE_DAT_FOLDER)
		{
			char sDirLoc[MAX_PATH];

			if(BrowseDirectory(hSQLDatFileLoc,
				"Select the directoy where the server will store SQL Database files.",
				BIF_RETURNONLYFSDIRS|BIF_USENEWUI, sDirLoc))
			{
				Set_Text(hSQLDatFileLoc, sDirLoc);
			}

			return TRUE;
		}
		return TRUE;
	}

	if(uMsg == WM_NOTIFY)
    {
        LPNMHDR pNMH = (LPNMHDR)lParam;
        if(pNMH->code == PSN_KILLACTIVE)
        {
            return FALSE;
        }
        if(pNMH->code == PSN_APPLY) // Ok
        {
			char sSQLDataFiles[MAX_PATH];
			int iSz = 0;

			gbCacheLogFile = (IsDlgButtonChecked(hWnd, IDC_CACHELOGFILE) == BST_CHECKED);
			gbRTOFDWI = (IsDlgButtonChecked(hWnd, IDC_RTOFDWI) == BST_CHECKED);
			gbStartAutomatically = (IsDlgButtonChecked(hWnd, IDC_AUTORUN) == BST_CHECKED);
			gbShowSplashScreen = (IsDlgButtonChecked(hWnd, IDC_SHOWSPLASHSCREEN) == BST_CHECKED);
			gbDropBadPackets = (IsDlgButtonChecked(hWnd, IDC_DROPBADPACKETS) == BST_CHECKED);
			gbPacketMode = (IsDlgButtonChecked(hWnd, IDC_USEPACKEMODE) == BST_CHECKED);
			gbVisualAlertOnError = (IsDlgButtonChecked(hWnd, IDC_ALERTONERRORS) == BST_CHECKED);
			gbVisualAlertOnWarn = (IsDlgButtonChecked(hWnd, IDC_ALERTONWARNING) == BST_CHECKED);

			iSz = Get_TextEx(hSQLDatFileLoc, sSQLDataFiles, sizeof(sSQLDataFiles));
			if(iSz <= 0 || iSz > sizeof(sSQLDataFiles))
			{
                MessageBox(hWnd, "You must enter a valid \"SQL Data File\" location.", gsTitleCaption, MB_ICONASTERISK);
                SetWindowLongPtr(hWnd, DWLP_MSGRESULT, PSNRET_INVALID_NOCHANGEPAGE); // Prevent window from closing
			}

			strcpy_s(gsSQLDataFiles, sizeof(gsSQLDataFiles), sSQLDataFiles);

			return TRUE;
        }
        if(pNMH->code == PSN_RESET) // Cancel
        {
            return FALSE;
        }
    }

    return FALSE;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif
